<?php
/**
 * Plugin Name: اضافه کردن توضیحات و تصویر به دسته بندی‌ها
 * Plugin URI: https://sitepich.com/
 * Description: ویرایشگر دیداری برای توضیحات دسته/برند با ذخیرهٔ کامل HTML (هدینگ، لیست، تصویر، چینش و ...)، حتی اگر افزونه‌های دیگر آن را محدود کنند. + تصویر بندانگشتی برای دسته‌بندی نوشته‌ها.
 * Version: 4.0
 * Author: You
 * License: GPLv2 or later
 * Text Domain: category-description-wysiwyg
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function cdw_loosen_term_kses_filters() {
    remove_filter( 'pre_term_description', 'wp_filter_kses' );
    remove_filter( 'term_description',     'wp_kses_data' );
    remove_filter( 'pre_term_description', 'wp_kses_data' );
}
add_action( 'init', 'cdw_loosen_term_kses_filters', 20 );
add_action( 'admin_init', 'cdw_loosen_term_kses_filters', 20 );

function cdw_enqueue_editor_assets( $hook ) {
    if ( ! in_array( $hook, array( 'edit-tags.php', 'term.php' ), true ) ) {
        return;
    }
    if ( function_exists( 'wp_enqueue_editor' ) ) {
        wp_enqueue_editor();
    }
    if ( function_exists( 'wp_enqueue_media' ) ) {
        wp_enqueue_media();
    }
}
add_action( 'admin_enqueue_scripts', 'cdw_enqueue_editor_assets' );

function cdw_enable_visual_editor_for_term_description() {
    if ( ! function_exists( 'get_current_screen' ) ) {
        return;
    }
    $screen = get_current_screen();
    if ( ! $screen || ! in_array( $screen->base, array( 'edit-tags', 'term' ), true ) ) {
        return;
    }
    ?>
    <script type="text/javascript">
    (function($){
        $(function(){
            if ( typeof wp === 'undefined' || !wp.editor || !wp.editor.initialize ) {
                return;
            }

            var $forms = $('#edittag, #addtag');

            $forms.each(function(){
                var $form = $(this);
                var $textarea = $form.find('textarea[name="description"]').first();
                if ( !$textarea.length ) {
                    return;
                }

                var id = $textarea.attr('id');
                if ( !id ) {
                    id = 'cdw_description_' + Math.floor( Math.random() * 1000000 );
                    $textarea.attr('id', id);
                }

                if ( $textarea.data('cdw-initialized') ) {
                    return;
                }
                $textarea.data('cdw-initialized', true);

                try {
                    wp.editor.initialize(id, {
                        tinymce: {
                            wpautop: true,
                            toolbar1: 'formatselect,bold,italic,link,bullist,numlist,blockquote,alignleft,aligncenter,alignright,undo,redo,alignjustify',
                            toolbar2: 'underline,forecolor,pastetext,removeformat,charmap,outdent,indent'
                        },
                        quicktags: true,
                        mediaButtons: true
                    });
                } catch (e) {
                    if ( window.console && console.warn ) {
                        console.warn('CDW init error', e);
                    }
                }

                $form.on('submit.cdwDescription', function(){
                    try {
                        if ( typeof wp !== 'undefined' && wp.editor && typeof wp.editor.save === 'function' ) {
                            wp.editor.save(id);
                        } else if ( typeof tinyMCE !== 'undefined' && typeof tinyMCE.triggerSave === 'function' ) {
                            tinyMCE.triggerSave();
                        } else if ( typeof tinymce !== 'undefined' && typeof tinymce.triggerSave === 'function' ) {
                            tinymce.triggerSave();
                        }
                    } catch (e) {
                        if ( window.console && console.warn ) {
                            console.warn('CDW save error', e);
                        }
                    }
                });
            });
        });
    })(jQuery);
    </script>
    <?php
}
add_action( 'admin_print_footer_scripts', 'cdw_enable_visual_editor_for_term_description', 20 );

function cdw_force_save_full_html_term_description( $term_id, $tt_id, $taxonomy ) {
    if ( ! is_admin() ) {
        return;
    }

    if ( ! isset( $_POST['description'] ) ) {
        return;
    }


    if ( current_user_can( 'unfiltered_html' ) ) {
        $raw  = wp_unslash( $_POST['description'] );
        $safe = $raw;
    } else {
        $raw  = wp_unslash( $_POST['description'] );
        $safe = wp_kses_post( $raw );
    }

    global $wpdb;
    

    $wpdb->update(
        $wpdb->term_taxonomy, 
        array( 'description' => $safe ),
        array( 'term_taxonomy_id' => (int) $tt_id )
    );
}
add_action( 'edited_term',  'cdw_force_save_full_html_term_description', 999, 3 );
add_action( 'created_term', 'cdw_force_save_full_html_term_description', 999, 3 );


add_action( 'category_add_form_fields', 'devix_category_thumb_add_field' );
function devix_category_thumb_add_field() {

    wp_nonce_field( 'devix_cat_thumb_save', 'devix_cat_thumb_nonce' );
    ?>
    <div class="form-field term-group">
        <label for="devix_cat_thumb">تصویر دسته‌بندی</label>

        <div class="devix-cat-thumb-wrap" style="margin-bottom:8px;">
            <img src="" alt="" style="max-width:120px;height:auto;display:none;border:1px solid #ddd;padding:2px;background:#fff;" />
        </div>

        <input type="hidden" id="devix_cat_thumb" name="devix_cat_thumb" value="" />

        <button type="button" class="button devix-cat-thumb-upload">انتخاب تصویر</button>
        <button type="button" class="button devix-cat-thumb-remove" style="display:none;">حذف تصویر</button>

        <p class="description">یک تصویر از رسانه انتخاب کنید.</p>
    </div>
<?php }

add_action( 'category_edit_form_fields', 'devix_category_thumb_edit_field' );
function devix_category_thumb_edit_field( $term ) {
    $thumb = get_term_meta( $term->term_id, 'devix_cat_thumb', true );

    wp_nonce_field( 'devix_cat_thumb_save', 'devix_cat_thumb_nonce' );
    ?>
    <tr class="form-field term-group-wrap">
        <th scope="row">
            <label for="devix_cat_thumb">تصویر دسته‌بندی</label>
        </th>
        <td>
            <div class="devix-cat-thumb-wrap" style="margin-bottom:8px;">
                <?php if ( $thumb ) : ?>
                    <img src="<?php echo esc_url( $thumb ); ?>" alt="" style="max-width:120px;height:auto;border:1px solid #ddd;padding:2px;background:#fff;" />
                <?php else : ?>
                    <img src="" alt="" style="max-width:120px;height:auto;display:none;border:1px solid #ddd;padding:2px;background:#fff;" />
                <?php endif; ?>
            </div>

            <input type="hidden"
                   id="devix_cat_thumb"
                   name="devix_cat_thumb"
                   value="<?php echo esc_attr( $thumb ); ?>" />

            <button type="button" class="button devix-cat-thumb-upload">انتخاب تصویر</button>
            <button type="button" class="button devix-cat-thumb-remove" <?php if ( ! $thumb ) echo 'style="display:none;"'; ?>>
                حذف تصویر
            </button>

            <p class="description">تصویر بندانگشتی دسته را از رسانه انتخاب کن.</p>
        </td>
    </tr>
<?php }

add_action( 'created_category', 'devix_save_category_thumb' );
add_action( 'edited_category',  'devix_save_category_thumb' );
function devix_save_category_thumb( $term_id ) {

    if ( ! isset( $_POST['devix_cat_thumb_nonce'] ) ) {
        return;
    }


    if ( ! wp_verify_nonce( $_POST['devix_cat_thumb_nonce'], 'devix_cat_thumb_save' ) ) {
        return;
    }


    if ( ! current_user_can( 'edit_term', $term_id ) ) {
        return;
    }

    if ( ! isset( $_POST['devix_cat_thumb'] ) ) {
        return;
    }

    $url = esc_url_raw( $_POST['devix_cat_thumb'] );

    if ( $url ) {
        update_term_meta( $term_id, 'devix_cat_thumb', $url );
    } else {
        delete_term_meta( $term_id, 'devix_cat_thumb' );
    }
}

add_action( 'admin_footer-edit-tags.php', 'devix_category_thumb_media_script' );
add_action( 'admin_footer-term.php',      'devix_category_thumb_media_script' );
function devix_category_thumb_media_script() {

    if ( isset( $_GET['taxonomy'] ) && $_GET['taxonomy'] !== 'category' ) {
        return;
    }

    ?>
    <script>
        jQuery(document).ready(function($){
            var frame;

            function devixSetCatThumb(url) {
                var $wrap   = $('.devix-cat-thumb-wrap'),
                    $img    = $wrap.find('img'),
                    $input  = $('#devix_cat_thumb'),
                    $remove = $('.devix-cat-thumb-remove');

                if (url) {
                    $img.attr('src', url).show();
                    $input.val(url);
                    $remove.show();
                } else {
                    $img.attr('src', '').hide();
                    $input.val('');
                    $remove.hide();
                }
            }
        
            $(document).on('click', '.devix-cat-thumb-upload', function(e){
                e.preventDefault();

                if (frame) {
                    frame.open();
                    return;
                }

                frame = wp.media({
                    title: 'انتخاب تصویر دسته‌بندی',
                    button: { text: 'استفاده از این تصویر' },
                    multiple: false
                });

                frame.on('select', function(){
                    var attachment = frame.state().get('selection').first().toJSON();
                    if (attachment && attachment.url) {
                        devixSetCatThumb(attachment.url);
                    }
                });

                frame.open();
            });

        
            $(document).on('click', '.devix-cat-thumb-remove', function(e){
                e.preventDefault();
                devixSetCatThumb('');
            });
        });
    </script>
    <?php
}

add_filter('manage_edit-category_columns', 'devix_overwrite_category_columns_advanced');
function devix_overwrite_category_columns_advanced($columns) {
    $new_columns = array();

    foreach ($columns as $key => $title) {
        if ($key === 'description') {
            $new_columns['devix_description_wrapped'] = 'توضیح'; 
        } else {
            $new_columns[$key] = $title;
        }
    }
    return $new_columns;
}
add_filter('manage_category_custom_column', 'devix_render_wrapped_description_advanced', 10, 3);
function devix_render_wrapped_description_advanced($content, $column_name, $term_id) {
    if ($column_name !== 'devix_description_wrapped') {
        return $content;
    }

    $term = get_term($term_id, 'category');

    if ( ! $term || empty($term->description) ) {
        return '<span style="color:#ccc;">—</span>';
    }


    if ( current_user_can( 'unfiltered_html' ) ) {
        $desc_html = $term->description;
    } else {
        $desc_html = wp_kses_post($term->description);
    }

    $edit_link = get_edit_term_link( $term_id, 'category' );

    $edit_btn_html = '';
    if ( $edit_link ) {
        $edit_btn_html = sprintf(
            '<a href="%s" class="devix-quick-edit-btn" title="ویرایش کامل این دسته">
                <span class="dashicons dashicons-edit"></span> ویرایش
             </a>',
            esc_url( $edit_link )
        );
    }

    return '<div class="devix-desc-scroll">' . $edit_btn_html . $desc_html . '</div>';
}

add_action('admin_head', 'devix_add_admin_styles_advanced');
function devix_add_admin_styles_advanced() {
    $screen = get_current_screen();
    if ( $screen && 'edit-tags' === $screen->base ) {
        ?>
        <style>
            .devix-desc-scroll {
                max-height: 100px;
                overflow: hidden;
                background-color: #fff;
                border: 1px solid #ddd;
                padding: 10px;
                border-radius: 4px;
                font-size: 12px;
                line-height: 1.6;
                position: relative;
                transition: border-color 0.2s;
            }
            .devix-desc-scroll:hover {
                border-color: #2271b1;
                box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            }
            .devix-quick-edit-btn {
                position: absolute;
                top: 5px;
                left: 5px;
                background-color: #2271b1;
                color: #fff !important;
                padding: 4px 8px;
                border-radius: 3px;
                text-decoration: none;
                font-size: 11px;
                display: flex;
                align-items: center;
                gap: 4px;
                opacity: 0;
                visibility: hidden;
                transform: translateY(-5px);
                transition: all 0.2s ease-in-out;
                z-index: 10;
                box-shadow: 0 2px 4px rgba(0,0,0,0.2);
            }
            .devix-quick-edit-btn .dashicons {
                font-size: 14px;
                width: 14px;
                height: 14px;
                line-height: 1.1;
            }
            .devix-quick-edit-btn:hover {
                background-color: #135e96;
                color: #fff !important;
            }
            .devix-desc-scroll:hover .devix-quick-edit-btn {
                opacity: 1;
                visibility: visible;
                transform: translateY(0);
            }
            .devix-desc-scroll::-webkit-scrollbar { 
                width: 5px; 
            }
            .devix-desc-scroll::-webkit-scrollbar-thumb { 
                background: #ccc; 
                border-radius: 3px; 
            }
            .column-devix_description_wrapped { 
                width: 45%; 
            }
        </style>
        <?php
    }
}